# ``docc``

@Metadata {
    @DisplayName("DocC")
}

Produce rich API reference documentation and interactive tutorials for your Swift framework or package.

## Overview

The DocC documentation compiler converts Markdown-based text into rich documentation for Swift frameworks and packages. You can preview the documentation in its published form as you work on it, and also host it on a website when it's complete.

DocC syntax — called _documentation markup_ — is a custom variant of Markdown that adds functionality for developer-specific documentation features, like cross-symbol linking, term-definition lists, code listings, and asides. You add documentation markup to your source code, compile it with DocC, and produce reference documentation for your APIs. You can also use documentation markup, along with a set of directives that instruct how DocC generates your content, to offer step-by-step tutorials that teach developers to use your APIs through interactive coding exercises.

![On the left, a diagram shows a blocked-out example of a compiled tutorial and Markdown. In the middle, a diagram shows a blocked-out example of Markdown. On the right, a diagram shows a blocked-out example of compiled developer documentation.](docc-hero)

## Topics

### Essentials

- <doc:documenting-a-swift-framework-or-package>

- <doc:writing-symbol-documentation-in-your-source-files>

### Structure and Formatting

- <doc:formatting-your-documentation-content>

- <doc:adding-structure-to-your-documentation-pages>

- <doc:adding-supplemental-content-to-a-documentation-catalog>

### Distribution

- <doc:distributing-documentation-to-other-developers>
- <doc:customizing-the-appearance-of-your-documentation-pages>

### Documentation Types

- <doc:api-reference-syntax>

- <doc:tutorial-syntax>

### Shared Syntax

- ``Comment``

<!-- Copyright (c) 2021 Apple Inc and the Swift Project authors. All Rights Reserved. -->
